from django.shortcuts import render,redirect
from .forms import *
from django.contrib.auth.models import User
from django.contrib.auth import authenticate,login,logout
from django.contrib import messages




def user_register(request):
    form = UserCreateForm(data=request.POST)

    if request.method == 'POST':
        if form.is_valid():
            account = form.save()
            account.refresh_from_db()  # load the profile instance created by the signal
            account.username = form.cleaned_data.get('username')
            account.age = form.cleaned_data.get('age')
            account.disease = form.cleaned_data.get('disease')
            account.address = form.cleaned_data.get('address')
            account.phone = form.cleaned_data.get('phone')
            account.first_name = form.cleaned_data.get('first_name')
            account.last_name = form.cleaned_data.get('last_name')
            account.save()
            raw_password = form.cleaned_data.get('password1')
            return redirect('home:home')
    return render(request, 'accounts/register.html', {'form': form})



def user_login(request):
    if request.method == 'POST':
        form = UserLoginForm(request.POST)
        if form.is_valid():
            data = form.cleaned_data
            user = authenticate(request, username=data['user'], password=data['password'])
            if user is not None:
                login(request,user)
                #messages.success(request,'Welcome')
                return redirect('home:home')
            else:
                messages.error(request,'user or password wrong!')
            
    else:
        form = UserLoginForm()
    return render(request,'accounts/login.html',{'form':form})



def user_logout(request):
    logout(request)
    #messages.warning(request,'Goodbye...')
    return redirect('home:home') 